% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.R
\name{sa}
\alias{sa}
\title{Flexible Monte Carlo sensitivity analysis for unmeasured confounding}
\usage{
sa(
  M.burnin,
  M.keep,
  M.thin = 1,
  status,
  y.train,
  x.train,
  trt.train,
  x.test,
  trt.test,
  cluster.id,
  verbose = FALSE,
  formula = NULL,
  prior_c_function,
  Q1,
  Q2 = NULL,
  nCores = 1,
  ...
)
}
\arguments{
\item{M.burnin}{A numeric value indicating the number of MCMC iterations to be treated as burn in.}

\item{M.keep}{A numeric value indicating the number of MCMC posterior draws after burn in.}

\item{M.thin}{A numeric value indicating the thinning parameter.}

\item{status}{A vector of event indicators: status = 1 indicates that the event was observed while status = 0 indicates the observation was right-censored.}

\item{y.train}{A vector of follow-up times.}

\item{x.train}{A dataframe or matrix, including all the covariates but not treatments for training data, with rows corresponding to observations and columns to variables.}

\item{trt.train}{A numeric vector representing the treatment groups for the training data.}

\item{x.test}{A dataframe, including all the covariates but not treatments for testing data, with rows corresponding to observations and columns to variables.}

\item{trt.test}{A numeric vector representing the treatment groups for the testing data.}

\item{cluster.id}{A vector of integers representing the clustering id.}

\item{verbose}{A logical indicating whether to show the progress bar. The default is FALSE}

\item{formula}{A \code{\link[stats]{formula}} object for the analysis. The default is to use all terms specified in \code{x.train}.}

\item{prior_c_function}{1) A vector of characters indicating the prior distributions for the confounding functions. Each character contains the random number generation code from the standard probability \code{\link[stats:Distributions]{distributions}} in the \code{\link[stats:stats-package]{stats}} package. 2) A vector of characters including the grid specifications for the confounding functions. It should be used when users want to formulate the  confounding  functions as scalar values. 3) A matrix indicating the point mass prior for the confounding functions}

\item{Q1}{A numeric value indicating the number of draws of the GPS from the posterior predictive distribution}

\item{Q2}{A numeric value indicating the number of draws from the prior distributions of the confounding functions}

\item{nCores}{A numeric value indicating number of cores to use for parallel computing.}

\item{...}{Other parameters that can be passed to BART functions}
}
\value{
A list of causal estimands including risk difference in terms of log time between different treatment groups.
}
\description{
The function \code{sa} implements the flexible sensitivity analysis approach for unmeasured confounding with multiple treatments from multilevel survival data.
}
\examples{
\donttest{
set.seed(20181223)
n = 50      # number of clusters
k = 50      # cluster size
N = n*k     # total sample size
cluster.id = rep(1:n, each=k)
tau.error = 0.8
b = rnorm(n, 0, tau.error)
alpha = 2
beta1 = 1
beta2 = -1
beta3 = -2
sig.error = 0.5
censoring.rate = 0.02
x1 = rnorm(N,0.5,1)
x2 = rnorm(N,1.5,0.5)
trt.train = sample(c(1,2,3), N, prob = c(0.4,0.3,0.2), replace = TRUE)
trt.test = sample(c(1,2,3), N, prob = c(0.3,0.4,0.2), replace = TRUE)
error = rnorm(N,0,sig.error)
logtime = alpha + beta1*x1 + beta2*x2 + b[cluster.id] + error
y = exp(logtime)
C = rexp(N, rate=censoring.rate) # censoring times
Y = pmin(y,C)
status = as.numeric(y<=C)
res_sa <- sa(M.burnin = 50, M.keep = 50, M.thin = 1, status = status,
             y.train = Y,trt.train = trt.train,trt.test = trt.test,
             x.train = cbind(x1,x2),
             x.test = cbind(x1,x2),
             cluster.id = cluster.id, verbose = F,prior_c_function = c(
               "runif(-0.6, 0)",# c(1,2)
               "runif(0, 0.6)",# c(2,1)
               "runif(-0.6, 0)", # c(2,3)
               "seq(-0.6, 0, by = 0.3)", # c(1,3)
               "seq(0, 0.6, by = 0.3)", # c(3,1)
              "runif(0, 0.6)" # c(3,2)
            ),Q1 = 1, nCores = 1)
 }
}
