% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructPedigree.R
\name{constructPedigree}
\alias{constructPedigree}
\title{Pedigree construction}
\usage{
constructPedigree(kappa, verbose = FALSE)
}
\arguments{
\item{kappa}{A probability vector of length 3; \eqn{(kappa0, kappa1,
kappa2)}{(\kappa_0, \kappa_1, \kappa_2)}.}

\item{verbose}{A logical. If TRUE, various details about the calculations are
printed, as well as a textual description of the resulting relationship.}
}
\value{
A \code{ped} object containing a pair of double half cousins with inbred
founders. (In corner cases the relationship collapses into siblings.)
}
\description{
Construct a pedigree yielding a prescribed set of IBD coefficients.
}
\details{
The construction follows the method and formulae given in Vigeland (2020).
}
\examples{

# Full siblings
kap = c(0.25, 0.5, 0.25)
x = constructPedigree(kap)

# Validation
kap2 = kappaIBD(x, leaves(x))
stopifnot(all.equal(kap, kap2))

# For kappa = (0,1,0), the result is not a parent-child relationship,
# but half siblings whose shared parent is completely inbred.
y = constructPedigree(kappa = c(0,1,0))
plot(y)

}
\references{
M. D. Vigeland (2020). \emph{Relatedness coefficients in pedigrees
with inbred founders}. Journal of mathematical biology.
\doi{https://doi.org/10.1007/s00285-020-01505-x}
}
