% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{coverage}
\alias{coverage}
\title{coverage of one distribution by another}
\usage{
coverage(
  distA,
  distB,
  n = 10000,
  k = 10,
  nameA = "A",
  nameB = "B",
  decimals = 4,
  seed = NA,
  visualise = TRUE,
  xlab = "cal BP"
)
}
\arguments{
\item{distA}{Distribution A. Expects two columns: values and their probabilities (e.g., caldist(130,10, cc=1)).}

\item{distB}{Distribution B. Expects two columns: values and their probabilities (e.g., caldist(130,10, cc=1)).}

\item{n}{The number of random points to be sampled (proportionally to the density of distribution A).}

\item{k}{The number of points to be sampled for each iteration n from distribution B. After this, the range of these samples values is calculated to obtain a width of distribution B within which the sampled values of distribution could fall (the more, the higher the coverage).}

\item{nameA}{The name of distribution A (for the plot's legend).}

\item{nameB}{The name of distribution B (for the plot's legend).}

\item{decimals}{Number of decimals to report - rounding is to 4 decimals by default.}

\item{seed}{For reproducibility, a seed can be set (e.g., \code{seed=123}). Defaults to NA, no seed set.}

\item{visualise}{Whether or not to plot the distributions. Defaults to TRUE.}

\item{xlab}{Label of the horizontal axis. Defaults to \code{xlab="cal BP"}.}
}
\value{
The coverage of distribution A within distribution B.
}
\description{
Samples n random points from distribution A (with higher likelihoods proportionally more likely to be sampled), and for each point checks whether distribution B covers that point. Then the proportion of points where A is covered by B is returned. Can also calculate the coverage of distribution B by distribution A (if both=TRUE). The value of the coverage can range between 0 (distribution A is not covered by distribution B) to 1 (B covers A completely).
}
\examples{
  distA <- caldist(130, 20, cc=0) # normal distribution
  distB <- caldist(130, 20, cc=1) # calibrated distribution
  plot(distB, type="l")
  lines(distA, col=2)
  coverage(distA, distB)
}
