##' Diceware word list (English)
##'
##' The English Diceware word list as provided at
##' \url{http://world.std.com/~reinhold/diceware.wordlist.asc}.  To
##' the extent that a word list is protected by copyright, A G
##' Reinhold licenses its rights to the English Diceware Wordlist
##' under the Creative Commons CC-BY 3.0 license. Diceware is a
##' trademark of Arnold G. Reinhold.
##' @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_en"

##' Diceware word list (German)
##'
##' The German Diceware word list as provided at
##' \url{http://world.std.com/~reinhold/diceware_german.txt}. This
##' list is provided by Benjamin Tenne under the terms of the GNU
##' General Public License.
##' @format A \code{data.frame} with  2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_de"

##' Diceware word list (Spanish)
##'
##' The Spanish Diceware word list as provided at
##' \url{http://world.std.com/~reinhold/diceware_espanol/DW-Espanol-1.txt}. This
##' list is provided by Manuel Palao, CISM, CISA (manuel@@palao.com) under the terms of the
##' GNU General Public License.
##' @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_es"

##' Diceware word list (French)
##'
##' The French Diceware list as provided at
##' \url{http://weber.fi.eu.org/software/diceware/src/francais.wordlist.asc}. This list is provided
##' by Matthieu Weber, no licensing information is provided.
##' @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_fr"

##' Diceware word list (Italian)
##'
##' The Italian Diceware list as provided at
##' \url{http://www.taringamberini.com/download/diceware_it_IT/word_list_diceware_in_italiano.txt}.
##' This list is provided by Tarin Gamberini under a GNU General Public License.
##' @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_it"

##' Diceware word list (Japanese)
##'
##' The Japanese Diceware list as provided at
##' \url{http://s3.amazonaws.com/dotclue.org/diceware_jp.txt}
##' translated by Hiroshi Yuki, and provided in Romaji by J Greely. No
##' license information provided.
##' @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_jp"

## too many encoding issues at this stage.
## dataset is in the github repo but not in the official package
## as I added it to .Rbuildignore
## Diceware word list (Dutch)
##
## The Dutch Diceware list as provided at
## \url{http://theworld.com/~reinhold/DicewareDutch.txt} provided by
## Bart Van den Eynde under the terms of the GNU Free Documentation
## License.
## @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
## number representing the results of 5 rolls of a dice, \code{word}
## the Diceware word corresponding to the dice rolls.
## "wordlist_nl"

##' Diceware word list (Swedish)
##'
##' The Swedish Diceware list as provided at
##' \url{http://x42.com/diceware/diceware-sv.txt} provided by by
##' Magnus Bodin. No license information provided.
##' @format A \code{data.frame} with 2 columns: \code{token} a 5-digit
##' number representing the results of 5 rolls of a dice, \code{word}
##' the Diceware word corresponding to the dice rolls.
##' @keywords datasets
"wordlist_sv"
