% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-sep3.R
\name{sep3}
\alias{sep3}
\alias{delta_cummin}
\alias{delta_start}
\alias{delta_min}
\title{Sepsis 3 label}
\usage{
sep3(
  ...,
  si_window = c("first", "last", "any"),
  delta_fun = delta_cummin,
  sofa_thresh = 2L,
  si_lwr = hours(48L),
  si_upr = hours(24L),
  keep_components = FALSE,
  interval = NULL
)

delta_cummin(x)

delta_start(x)

delta_min(x, shifts = seq.int(0L, 23L))
}
\arguments{
\item{...}{Data objects}

\item{si_window}{Switch that can be used to filter SI windows}

\item{delta_fun}{Function used to determine the SOFA increase during an SI
window}

\item{sofa_thresh}{Required SOFA increase to trigger Sepsis 3}

\item{si_lwr, si_upr}{Lower/upper extent of SI windows}

\item{keep_components}{Logical flag indicating whether to return the
individual components alongside the aggregated score}

\item{interval}{Time series interval (only used for checking consistency
of input data)}

\item{x}{Vector of SOFA scores}

\item{shifts}{Vector of time shifts (multiples of the current interval) over
which \code{\link[base:Extremes]{base::pmin()}} is evaluated}
}
\description{
The sepsis 3 label consists of a suspected infection combined with an acute
increase in SOFA score.
}
\details{
The Sepsis-3 Consensus (Singer et. al.) defines sepsis as an acute
increase in the SOFA score (see \code{\link[=sofa_score]{sofa_score()}}) of 2 points or more within
the suspected infection (SI) window (see \code{\link[=susp_inf]{susp_inf()}}):
\figure{sofa-sep-3-1.png}

A patient can potentially have multiple SI windows. The argument
\code{si_window} is used to control which SI window we focus on (options are
\verb{"first", "last", "any"}).

Further, although a 2 or more point increase in the SOFA score is defined,
it is not perfectly clear to which value the increase refers. For this the
\code{delta_fun} argument is used. If the increase is required to happen with
respect to the minimal SOFA value (within the SI window) up to the current
time, the \code{delta_cummin} function should be used. If, however, we are
looking for an increase with respect to the start of the SI window, then
the \code{delta_start} function should be used. Lastly, the increase might be
defined with respect to values of the previous 24 hours, in which case the
\code{delta_min} function is used.
}
\references{
Singer M, Deutschman CS, Seymour CW, et al. The Third International
Consensus Definitions for Sepsis and Septic Shock (Sepsis-3). JAMA.
2016;315(8):801–810. doi:10.1001/jama.2016.0287
}
