% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.rifreg}
\alias{plot.rifreg}
\title{Plot the coefficients of a \code{rifreg} object}
\usage{
\method{plot}{rifreg}(
  x,
  varselect = NULL,
  confidence_level = 0.05,
  vcov = sandwich::sandwich,
  ...
)
}
\arguments{
\item{x}{an object of class "rifreg", usually, a result of a call to \link[rifreg]{rifreg} with \code{statistic = "quantiles"}.}

\item{varselect}{vector of length 1 or more containig the names of the covariates to display.}

\item{confidence_level}{numeric value between 0 and 1 (default = 0.95) that defines the confidence interval
plotted as a ribbon and defined as \code{qnorm(confidence_level/2)} * standard error.}

\item{vcov}{Function to estimate covariance matrix of rifreg coefficients if covariance matrix has not been bootstrapped.
Per default, heteroscedasticity-consistent (HC) standard errors are calculated using \link[sandwich]{sandwich}.
Note: These standard errors do not take the variance introduced by estimating RIF into account.}

\item{...}{other parameters to be passed to plotting function. See \link[ggplot2]{ggplot} for further information.}
}
\value{
a "ggplot" containing the coefficients for each (selected) covariate
}
\description{
Coefficients are plotted for each quantile and each covariate.
Specific covariates can be selected and standard errors displayed if desired.
}
\examples{

rifreg <- rifreg(
  formula = log(wage) ~ union +
    nonwhite +
    married +
    education +
    experience,
  data = men8385,
  statistic = "quantiles",
  probs = seq(0.1, 0.9, 0.1),
  weights = weights
)

plot(rifreg)

plot(rifreg, varselect = c("age", "unionyes"), confidence_level = 0.1)

}
