% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ticker_info.R
\name{is_supported_ticker}
\alias{is_supported_ticker}
\alias{supported_tickers}
\title{Ticker information}
\usage{
is_supported_ticker(ticker, type = "tiingo")

supported_tickers(type = "tiingo")
}
\arguments{
\item{ticker}{The single ticker to check for on Tiingo.}

\item{type}{One of: \code{"tiingo"}, \code{"iex"}, or \code{"crypto"}.}
}
\description{
\code{\link[=is_supported_ticker]{is_supported_ticker()}} can tell you if a given ticker is supported on Tiingo.
\code{\link[=supported_tickers]{supported_tickers()}} returns a \code{tibble} listing every available ticker.
}
\examples{

\dontrun{

# VOO is supported on both Tiingo and IEX
is_supported_ticker("VOO")
is_supported_ticker("VOO", type = "iex")

# PRHSX is a mutual fund that is supported by Tiingo but not IEX
is_supported_ticker("PRHSX")
is_supported_ticker("PRHSX", type = "iex")

# BTCUSD is available
is_supported_ticker("btcusd", type = "crypto")

}

}
