% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{maxima.engine}
\alias{maxima.engine}
\alias{maxima.inline}
\title{\code{knitr} maxima engine}
\usage{
maxima.engine(options)

maxima.inline(command)
}
\arguments{
\item{options}{named \code{list} of \code{knitr} options. Supported options are \code{echo}, \code{eval}, \code{include} and \code{output.var}. To change the output format of the Maxima engine set the option \code{maxima.options(engine.format)} to either \code{"linear"} (default), \code{"ascii"}, \code{"latex"} or \code{"mathml"}.}

\item{command}{character string containing the Maxima command to be executed.}
}
\value{
This functions prints the resulting output from maxima together with it's code

character string containing the maxima result printed according options set by \code{maxima.options(inline.format = ..., inline.label = ...)}.
}
\description{
Functions to process Maxima code chunks by \code{knitr}.
}
\details{
Upon attachment, i.e. \code{library(rim)} function \code{maxima.engine} is registered as a \code{knitr} engine. Thus, \code{maxima.engine()} is called by \code{knit()} to evaluate Maxima code chunks. When called upon the first code chunk of a document it starts Maxima in a separate process in server mode. This means that a single Maxima session is used for all Maxima code chunks of an \code{RMarkdown} document. Inputs and outputs can thus be used across chunks (e.g. by using Maxima reference labels). \code{maxima.options(engine.format = ..., engine.label = ...)} configures the output format and whether or not output reference labels should be printed.

The purpose of \code{maxima.inline} is to insert Maxima results as inline text, i.e. on the same line of the preceding text, if it is actually written on the same line of the \code{RMarkdown} file. It uses the same running Maxima process as \code{maxima.engine}. The output format for inline results can be configured separately from the settings of \code{maxima.engine}, i.e. \code{maxima.options(inline.format = ..., inline.label = ...)}.
}
\section{Functions}{
\itemize{
\item \code{maxima.inline()}: This function can be used to insert maxima outputs as inline.

}}
\examples{
if(maxima.isInstalled()) {
  maxima.inline("2+2;")
  maxima.stop(engine = TRUE)
}
}
