#' Artificial example data on housing conditions
#'
#' Microdata with a permissive license that includes continuous data on health and income is hard to come by. In stead of real data, the package thus includes an imaginary dataset.
#' 
#' @format \code{data.frame} object. 
#'
#' Variable list: 
#' \describe{
#' \item{id}{unique identifier per person}
#' \item{sex}{female or male}
#' \item{age}{integer, from 20 to 94}
#' \item{tenure}{categorical. One of homeless, irregular, own_apartment, own_house, or rent}
#' \item{height}{height in cm }
#' \item{weight}{weight in kg}
#' \item{bmi}{weight/(height/100)^2}
#' \item{income}{continuous, imaginary currency without unit}
#'}
#' @docType data
#'
#' @usage data(housing)
#' 
#' @source Artificially generated by the package authors
#'
#' @keywords datasets
#'
"housing"