% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriestotpm.R
\name{series_to_tpm}
\alias{series_to_tpm}
\title{Time Series to TPM}
\usage{
series_to_tpm(series)
}
\arguments{
\item{series}{Vector or matrix specifying one or more time series.}
}
\value{
Matrix giving the corresponding transition probability matrix.
}
\description{
Estimate the one-time-step transition probability matrix `A` from a time
series. The element `A_{ji}` is the probability of transitioning to state
`j` in the next time step given the system is in state `i` (note the
column-major convention).
}
\examples{
# TPM from 2 base-2 time series
xs      <- matrix(0, nrow = 5, ncol = 2)
xs[, 1] <- c(0, 0, 1, 1, 0)
xs[, 2] <- c(1, 0, 1, 1, 1)
series_to_tpm(xs)

# TPM from one base-3 time series
xs <- c(0, 1, 2, 2, 1, 1, 0, 0, 1, 2)
series_to_tpm(xs)
}
