% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{accumulate}
\alias{accumulate}
\title{Accumulate}
\usage{
accumulate(d, events)
}
\arguments{
\item{d}{Dist object representing the distribution.}

\item{events}{Numeric representing the observed events.}
}
\value{
Dist giving the updated distribution.
}
\description{
Generic function to make accumulate observations from a series. If an invalid
distribution is provided, no events will be observed. If an invalid event is
provided, then the number of valid events to that point will be added to the
distribution and a warning will be raised.
}
\examples{
# Accumulate observations to a distribution from collected events
d  <- Dist(c(5, 5))
dump(d)

xs <- sample(0:1, 10, TRUE)
d  <- accumulate(d, xs)
dump(d)

xs      <- matrix(0, 10, 3)
xs[, 1] <- sample(0:1, 10, TRUE)
xs[, 2] <- sample(2:3, 10, TRUE)
xs[, 3] <- sample(0:2, 10, TRUE)
d  <- accumulate(d, xs)
dump(d)
}
