% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{approximate}
\alias{approximate}
\title{Approximate}
\usage{
approximate(probs, tol)
}
\arguments{
\item{probs}{Numeric vector giving a probability distribution.}

\item{tol}{Numeric giving the tolerance.}
}
\value{
Dist object approximate from \code{probs} with tolerance \code{tol}.
}
\description{
Approximate a given probability distribution \code{probs} to a given
tolerance \code{tol}.
}
\examples{
# Approximate distributions with different tolerance
p <- c(0.12345, 0.23456, 1.0 - 0.12345 - 0.23456)
d <- approximate(p, tol = 0.1)
dump(d)

d <- approximate(p, tol = 0.001)
dump(d)

d <- approximate(p, tol = 0.00001)
dump(d)

}
