% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activeinfo.R
\name{active_info}
\alias{active_info}
\title{Active Information}
\usage{
active_info(series, k, local = FALSE)
}
\arguments{
\item{series}{Vector or matrix specifying one or more time series.}

\item{k}{Integer giving the history length.}

\item{local}{Boolean specifying whether to compute the local active
information.}
}
\value{
Numeric giving the average active information or a vector giving the
        local active information.
}
\description{
Compute the average or local active information of a time series with history
length \code{k}.
}
\examples{
# The typical usage is to provide the time series and the history length. 
xs <- c(0, 0, 1, 1, 1, 1, 0, 0, 0)
active_info(xs, k = 2) # 0.3059585
# [-0.1926451,  0.8073549,  0.2223924,  0.2223924, -0.3625701, 1.222392,
#  0.2223924]
active_info(xs, k = 2, local = TRUE)

# Multiple Initial Conditions
xs      <- matrix(0, nrow = 9, ncol = 2)
xs[, 1] <- c(0, 0, 1, 1, 1, 1, 0, 0, 0)
xs[, 2] <- c(1, 0, 0, 1, 0, 0, 1, 0, 0)
active_info(xs, k = 2) # 0.359879
# [, 1] 0.8073549, -0.3625701,  0.6374299,  0.6374299, -0.7776076, 0.8073549,
#      -1.192645
# [, 2] 0.8073549,  0.8073549,  0.2223924,  0.8073549,  0.8073549, 0.2223924,
#      0.8073549
active_info(xs, k = 2, local = TRUE)

}
