% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.D14C}
\alias{draw.D14C}
\title{Draw d14C and the calibration curve.}
\usage{
draw.D14C(
  cal1 = c(),
  cal2 = c(),
  cc = ccurve(),
  BCAD = FALSE,
  mar = c(4, 4, 1, 4),
  mgp = c(2.5, 1, 0),
  xaxs = "r",
  yaxs = "r",
  bty = "u",
  ka = FALSE,
  cal.lab = c(),
  cal.rev = FALSE,
  C14.lab = c(),
  C14.lim = c(),
  cc.col = rgb(0, 0.5, 0, 0.5),
  cc.border = rgb(0, 0.5, 0, 0.5),
  D14C.lab = c(),
  D14C.lim = c(),
  D14C.col = rgb(0, 0, 1, 0.5),
  D14C.border = rgb(0, 0, 1, 0.5)
)
}
\arguments{
\item{cal1}{First calendar year for the plot. Defaults to youngest calendar age of the calibration curve}

\item{cal2}{Last calendar year for the plot. Defaults to oldest calendar age of the calibration curve}

\item{cc}{The calibration curve to use. Defaults to IntCal20}

\item{BCAD}{The calendar scale of graphs and age output-files is in cal BP (calendar or calibrated years before the present, where the present is AD 1950) by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{mar}{Plot margins (amount of white space along edges of axes 1-4).}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted).}

\item{xaxs}{Whether or not to extend the limits of the horizontal axis. Defaults to \code{xaxs="r"} which extends it by R's default.}

\item{yaxs}{Whether or not to extend the limits of the vertical axis. Defaults to \code{yaxs="r"} which extends it by R's default.}

\item{bty}{Draw a box around the graph ("n" for none, and "l", "7", "c", "u", "]" or "o" for correspondingly shaped boxes).}

\item{ka}{Use kcal BP (and C14 kBP). Defaults to FALSE.}

\item{cal.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}), or to \code{age.lab="kcal BP"} etc. if ka=TRUE.}

\item{cal.rev}{Reverse the calendar axis (defaults to FALSE).}

\item{C14.lab}{Label for the C-14 axis. Defaults to 14C BP (or 14C kBP if ka=TRUE).}

\item{C14.lim}{Limits for the C-14 axis. Calculated automatically by default.}

\item{cc.col}{Colour of the calibration curve (fill).}

\item{cc.border}{Colour of the calibration curve (border).}

\item{D14C.lab}{Label for the D14C axis.}

\item{D14C.lim}{Axis limits for the D14C axis. Calculated automatically by default.}

\item{D14C.col}{Colour of the D14C curve (fill).}

\item{D14C.border}{Colour of the D14C curve (border).}
}
\value{
A plot of d14C and the calibration curve
}
\description{
Draw a proxy of the atmospheric 14C concentration (d14C) as well as the calibration curve.
}
\examples{
  draw.D14C()
  draw.D14C(30e3, 55e3, ka=TRUE)
  draw.D14C(cc=ccurve("NH1_monthly"), BCAD=TRUE)
}
