% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irods-s3.R
\name{as.data.frame.irods_df}
\alias{as.data.frame.irods_df}
\title{Coerce to a Data Frame}
\usage{
\method{as.data.frame}{irods_df}(x, ...)
}
\arguments{
\item{x}{\code{irods_df} class object.}

\item{...}{Currently not implemented}
}
\value{
Returns a \code{data.frame}. Note, that the
columns of metadata consists of a list of data frames, and status_information
and permission_information consist of data frames.
}
\description{
Coerce iRODS Zone information class to \code{\link[=data.frame]{data.frame()}}.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authenticate
iauth("rods", "rods")

# some data
foo <- data.frame(x = c(1, 8, 9), y = c("x", "y", "z"))

# store data in iRODS
isaveRDS(foo, "foo.rds")

# add some metadata
imeta(
  "foo.rds",
  "data_object",
  operations =
    data.frame(operation = "add", attribute = "foo", value = "bar",
      units = "baz")
)

# iRODS Zone with metadata
irods_zone <- ils(metadata = TRUE)

# check class
class(irods_zone)

# coerce into `data.frame` and extract metadata of "foo.rds"
irods_zone <- as.data.frame(irods_zone)
irods_zone[basename(irods_zone$logical_path) == "foo.rds", "metadata"]

# delete object
irm("foo.rds", force = TRUE)
\dontshow{\}) # examplesIf}
}
