% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-objects.R
\name{iput}
\alias{iput}
\alias{isaveRDS}
\title{Save Files and Objects in iRODS}
\usage{
iput(
  local_path,
  logical_path,
  offset = 0,
  count = 2000L,
  truncate = TRUE,
  verbose = FALSE,
  overwrite = FALSE
)

isaveRDS(
  x,
  logical_path,
  offset = 0,
  count = 2000L,
  truncate = TRUE,
  verbose = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{local_path}{Local path of file to be sent to iRODS.}

\item{logical_path}{Destination path in iRODS.}

\item{offset}{Offset in bytes into the data object. Defaults to 0.}

\item{count}{Maximum number of bytes to write. Defaults to 2000.}

\item{truncate}{Whether to truncate the object when opening it. Defaults to
\code{TRUE}.}

\item{verbose}{Whether to print information about the HTTP request and
response. Defaults to \code{FALSE}.}

\item{overwrite}{Whether the file in iRODS should be overwritten if it
exists. Defaults to \code{FALSE}.}

\item{x}{R object to save in iRODS.}
}
\value{
(Invisibly) the HTTP response.
}
\description{
Store an object or file into iRODS. \code{\link[=iput]{iput()}} should be used to transfer
a file from the local storage to iRODS; \code{\link[=isaveRDS]{isaveRDS()}} saves an R object from
the current environment in iRODS in RDS format (see \code{\link[=saveRDS]{saveRDS()}}).
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

\dontshow{
.old_wd <- setwd(tempdir())
}
# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home", TRUE)

# authenticate
iauth("rods", "rods")

# save the iris dataset as csv and send the file to iRODS
write.csv(iris, "iris.csv")
iput("iris.csv", "iris.csv")

# save with a different name
iput("iris.csv", "iris_in_irods.csv")
ils()

# send an R object to iRODS in RDS format
isaveRDS(iris, "iris_in_rds.rds")

# delete objects in iRODS
irm("iris_in_irods.csv", force = TRUE)
irm("iris_in_rds.rds", force = TRUE)
irm("iris.csv", force = TRUE)

\dontshow{
setwd(.old_wd)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=iget]{iget()}} for obtaining files,
\code{\link[=ireadRDS]{ireadRDS()}} for obtaining R objects from iRODS,
\code{\link[=readRDS]{readRDS()}} for an R equivalent.
}
