% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bioconductor_data.R
\name{fetch_bioconductor_package_info}
\alias{fetch_bioconductor_package_info}
\title{Fetch Bioconductor Package Information}
\usage{
fetch_bioconductor_package_info(bioconductor_version, package_name)
}
\arguments{
\item{bioconductor_version}{A character string specifying the Bioconductor version (e.g., "3.14").}

\item{package_name}{A character string specifying the name of the package.}
}
\value{
A list containing package details, including the latest version, package URL,
        source package link, and any archived versions if available.
        Returns `FALSE` if the package does not exist or cannot be retrieved.
}
\description{
This function retrieves information about a specific Bioconductor package
for a given Bioconductor version. It fetches the package details, such as
version, source package URL, and archived versions if available.
}
\examples{
\dontrun{
fetch_bioconductor_package_info("3.14", "GenomicRanges")

}
}
