% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.CauseSpecificCox.R
\name{seCSC}
\alias{seCSC}
\title{Standard error of the absolute risk predicted from cause-specific Cox models}
\usage{
seCSC(hazard, cumhazard, object.time, object.maxtime, iid, eXb_h, eXb_cumH,
  new.LPdata, new.strata, times, new.n, cause, nCause, return.se)
}
\arguments{
\item{hazard}{list containing the baseline hazard for each cause in a matrix form. Columns correspond to the strata.}

\item{cumhazard}{list containing the cumulative baseline hazard for each cause in a matrix form. Columns correspond to the strata.}

\item{object.time}{a vector containing all the events regardless to the cause.}

\item{object.maxtime}{a matrix containing the latest event in the strata of the observation for each cause.}

\item{iid}{the value of the influence function for each cause}

\item{eXb_h}{a matrix containing the exponential of the linear predictor evaluated for the new observations (rows) for each cause (columns)}

\item{eXb_cumH}{same as before except when considering \code{survtype == "survival"}}

\item{new.LPdata}{a list of design matrices for the new observations for each cause.}

\item{new.strata}{a matrix containing the strata indicator for each observation and each cause.}

\item{times}{the time points at which to evaluate the predictions.}

\item{new.n}{the number of new observations.}

\item{cause}{the cause of interest.}

\item{nCause}{the number of causes.}

\item{return.se}{Logical. Should the standard error be output. Otherwise the value of the influence function will be output.}
}
\description{
Standard error of the absolute risk predicted from cause-specific Cox models.
}
\examples{

set.seed(10)
d <- SimCompRisk(2e1)
d$time <- round(d$time,1)
ttt <- unique(sort(d$time))#sort(sample(x = unique(sort(d$time)), size = 10))

#### coxph function
CSC.fit <- CSC(Hist(time,event)~ X1+X2,data=d, method = "breslow")

predCSC <- predict(CSC.fit, newdata = d[1,,drop=FALSE], cause = 2, times = ttt, se = TRUE)


}

