% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSeCSC.R
\name{calcSeCSC}
\alias{calcSeCSC}
\title{Standard error of the absolute risk predicted from cause-specific Cox models}
\usage{
calcSeCSC(object, cif, hazard, cumhazard, object.time, object.maxtime, eXb,
  new.LPdata, new.strata, times, survtype, new.n, cause, nCause, nVar,
  logTransform, export, store.iid)
}
\arguments{
\item{object}{The fitted cause specific Cox model}

\item{cif}{the cumulative incidence function at each prediction time for each individual.}

\item{hazard}{list containing the baseline hazard for each cause in a matrix form. Columns correspond to the strata.}

\item{cumhazard}{list containing the cumulative baseline hazard for each cause in a matrix form. Columns correspond to the strata.}

\item{object.time}{a vector containing all the events regardless to the cause.}

\item{object.maxtime}{a matrix containing the latest event in the strata of the observation for each cause.}

\item{eXb}{a matrix containing the exponential of the linear predictor evaluated for the new observations (rows) for each cause (columns)}

\item{new.LPdata}{a list of design matrices for the new observations for each cause.}

\item{new.strata}{a matrix containing the strata indicator for each observation and each cause.}

\item{times}{the time points at which to evaluate the predictions.}

\item{survtype}{see the survtype argument of \code{\link{CSC}}.}

\item{new.n}{the number of new observations.}

\item{cause}{the cause of interest.}

\item{nCause}{the number of causes.}

\item{nVar}{the number of variables that form the linear predictor in each Cox model}

\item{logTransform}{Should the variance/influence function be computed on the log(-log) scale}

\item{export}{can be "iid" to return the value of the influence function for each observation
"se" to return the standard error for a given timepoint}

\item{store.iid}{the method used to compute the influence function and the standard error.
Can be \code{"full"} or \code{"minimal"}. See the details section.}
}
\description{
Standard error of the absolute risk predicted from cause-specific Cox models
using a first order von Mises expansion of the absolute risk functional.
}
\details{
Can also return the empirical influence function of the functionals cumulative hazard or survival
or the sum over the observations of the empirical influence function.

\code{store.iid="full"} compute the influence function for each observation at each time in the argument \code{times}
before computing the standard error / influence functions.
\code{store.iid="minimal"} recompute for each subject specific prediction the influence function for the baseline hazard.
This avoid to store all the influence functions but may lead to repeated evaluation of the influence function.
This solution is therefore efficient more efficient in memory usage but may not be in term of computation time.
}
