% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictCoxPL.R
\name{predictCoxPL}
\alias{predictCoxPL}
\title{Computation of survival probabilities from Cox regression models using the product limit estimator.}
\usage{
predictCoxPL(object, newdata, times, type = c("cumhazard", "survival"),
  se = FALSE, band = FALSE, ...)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package) or \code{cph}
(rms package).}

\item{newdata}{A \code{data.frame} or \code{data.table} containing
the values of the predictor variables defining subject specific
predictions. Should have the same structure as the data set
used to fit the \code{object}.}

\item{times}{Time points at which to evaluate the predictions.}

\item{type}{the type of predicted value. 
Choices are \code{"hazard"}, \code{"cumhazard"}, and \code{"survival"}. 
See \code{\link{predictCox}} for more details.}

\item{se}{Logical. If \code{TRUE} add the standard error to the output.}

\item{band}{Logical. If \code{TRUE} add the confidence band to the output.}

\item{...}{additional arguments to be passed to \code{\link{predictCox}}.}
}
\description{
Same as predictCox except that the survival is estimated using the product limit estimator.
}
\examples{
library(survival)

set.seed(10)
d <- sampleData(40,outcome="survival")
nd <- sampleData(4,outcome="survival")
d$time <- round(d$time,1)
fit <- coxph(Surv(time,event)~X1 + strata(X2) + X6,
             data=d, ties="breslow", x = TRUE, y = TRUE)
predictCoxPL(fit, newdata = d, times = 1:5)
fit <- coxph(Surv(time,event)~X1 + X2 + X6,
             data=d, ties="breslow", x = TRUE, y = TRUE)
predictCoxPL(fit, newdata = d, times = 1:5)


#### Compare exp to product limit
set.seed(10)
A <- predictCoxPL(fit, newdata = d[1:5], times = 1:5, se = TRUE, band = TRUE, log.transform = FALSE)
set.seed(10)
B <- predictCox(fit, newdata = d[1:5], times = 1:5, se = TRUE, band = TRUE, log.transform = FALSE)

A$survival - B$survival
A$survival.lower - B$survival.lower
A$survival.upper - B$survival.upper
A$survival.lowerBand - B$survival.lowerBand
A$survival.upperBand - B$survival.upperBand
}
