% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iptw_diagnostics.R
\name{check_iptw_assumptions}
\alias{check_iptw_assumptions}
\title{Check IPTW Assumptions}
\usage{
check_iptw_assumptions(
  iptw_result,
  balance_threshold = 0.1,
  extreme_weight_threshold = 10,
  verbose = TRUE
)
}
\arguments{
\item{iptw_result}{An iptw_result object from calc_iptw_weights()}

\item{balance_threshold}{Threshold for acceptable standardized difference (default: 0.1)}

\item{extreme_weight_threshold}{Threshold for flagging extreme weights (default: 10)}

\item{verbose}{Whether to print detailed diagnostics (default: TRUE)}
}
\value{
A list containing:
\describe{
\item{overall_assessment}{Character indicating "PASS", "CAUTION", or "FAIL"}
\item{positivity}{List with positivity checks and recommendations}
\item{balance}{List with balance assessment and problematic variables}
\item{weights}{List with weight distribution diagnostics}
\item{recommendations}{Character vector of specific recommendations}
}
}
\description{
Provides diagnostic checks for key IPTW assumptions including positivity,
balance, and model specification. Returns a comprehensive summary with
recommendations for potential issues.
}
\examples{
data(cachar_sample)

iptw_result <- calc_iptw_weights(
  data = cachar_sample,
  treatment = "areca_nut",
  covariates = c("age", "sex", "residence", "smoking")
)

# Check assumptions
assumptions <- check_iptw_assumptions(iptw_result)
print(assumptions$overall_assessment)
print(assumptions$recommendations)

}
