% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{risk_mod_random_start}
\alias{risk_mod_random_start}
\title{Run risk model with random start}
\usage{
risk_mod_random_start(
  X,
  y,
  weights = NULL,
  lambda0 = 0,
  a = -10,
  b = 10,
  max_iters = 100,
  tol = 1e-05,
  seed = NULL,
  nstart = 5
)
}
\arguments{
\item{X}{Input covariate matrix with dimension \eqn{n \times p};
every row is an observation.}

\item{y}{Numeric vector for the (binomial) response variable.}

\item{weights}{Numeric vector of length \eqn{n} with weights for each
observation. Unless otherwise specified, default will give equal weight to
each observation.}

\item{lambda0}{Penalty coefficient for L0 term (default: 0).
See \code{\link[=cv_risk_mod]{cv_risk_mod()}} for \code{lambda0} tuning.}

\item{a}{Integer lower bound for coefficients (default: -10).}

\item{b}{Integer upper bound for coefficients (default: 10).}

\item{max_iters}{Maximum number of iterations (default: 100).}

\item{tol}{Tolerance for convergence (default: 1e-5).}

\item{seed}{An integer that is used as argument by \code{set.seed()} for
offsetting the random number generator. Default is to not set a
particular randomization seed.}

\item{nstart}{Number of different random starts to try
(default: 5).}
}
\description{
Runs \code{nstart} iterations of \code{risk_mod()}, each with a different
warm start, and selects the best model. Each coefficient start is
randomly selected as -1, 0, or 1.
}
