% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_accu.R
\docType{data}
\name{accu}
\alias{accu}
\title{A list containing current accuracy information.}
\format{An object of class \code{list} of length 5.}
\usage{
accu
}
\description{
\code{accu} contains current accuracy information
returned by the corresponding generating function
\code{\link{comp_accu}}.
}
\details{
Current metrics include:

\enumerate{

\item \code{acc}: Overall accuracy as the proportion (or probability)
   of correctly classifying cases or of \code{\link{dec.cor}} cases:

\code{acc = dec.cor/N = (hi + cr)/(hi + mi + fa + cr)}

Values range from 0 (no correct prediction) to 1 (perfect prediction).

\item \code{wacc}: Weighted accuracy, as a weighted average of the
   sensitivity \code{\link{sens}} (aka. hit rate \code{\link{HR}}, \code{\link{TPR}},
   \code{\link{power}} or \code{\link{recall}})
   and the the specificity \code{\link{spec}} (aka. \code{\link{TNR}})
   in which \code{\link{sens}} is multiplied by a weighting parameter \code{w}
   (ranging from 0 to 1) and \code{\link{spec}} is multiplied by
   \code{w}'s complement \code{(1 - w)}:

\code{wacc = (w * sens) + ((1 - w) * spec)}

If \code{w = .50}, \code{wacc} becomes \emph{balanced} accuracy \code{bacc}.

\item \code{mcc}: The Matthews correlation coefficient (with values ranging from -1 to +1):

\code{mcc = ((hi * cr) - (fa * mi)) / sqrt((hi + fa) * (hi + mi) * (cr + fa) * (cr + mi))}

A value of \code{mcc = 0} implies random performance; \code{mcc = 1} implies perfect performance.

See \href{https://en.wikipedia.org/wiki/Matthews_correlation_coefficient}{Wikipedia: Matthews correlation coefficient}
   for additional information.

\item \code{f1s}: The harmonic mean of the positive predictive value \code{\link{PPV}}
   (aka. \code{\link{precision}})
   and the sensitivity \code{\link{sens}} (aka. hit rate \code{\link{HR}},
   \code{\link{TPR}}, \code{\link{power}} or \code{\link{recall}}):

\code{f1s =  2 * (PPV * sens) / (PPV + sens)}

See \href{https://en.wikipedia.org/wiki/F1_score}{Wikipedia: F1 score} for additional information.

}

Note that some accuracy metrics can be interpreted
as probabilities (e.g., \code{acc}) or correlations (e.g., \code{mcc}).
}
\examples{
accu <- comp_accu()  # => computes current accuracy information and saves results in accu
accu                 # => shows current accuracy information

}
\seealso{
The corresponding generating function \code{\link{comp_accu}};
\code{\link{num}} for basic numeric parameters;
\code{\link{freq}} for current frequency information;
\code{\link{prob}} for current probability information;
\code{\link{txt}} for current text settings.

Other lists containing current scenario information: \code{\link{freq}},
  \code{\link{num}}, \code{\link{pal}}, \code{\link{prob}},
  \code{\link{txt}}

Other metrics: \code{\link{comp_accu}},
  \code{\link{comp_acc}}
}
\keyword{datasets}
