% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_accu.R
\name{comp_acc}
\alias{comp_acc}
\title{Compute overall accuracy (acc) from probabilities.}
\usage{
comp_acc(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
Overall accuracy \code{acc} as a proportion (probability).
A warning is provided for NaN values.

See \code{\link{comp_accu}} and \code{\link{accu}} for
accuracy metrics based on frequencies.
}
\description{
\code{comp_acc} computes overall accuracy \code{acc}
from 3 essential probabilities
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}.
}
\details{
\code{comp_acc} uses probabilities (not frequencies) as
inputs and returns a proportion (probability)
without rounding.

Definition: \code{acc} is the overall accuracy
as the proportion (or probability)
of correctly classifying cases or of \code{\link{dec.cor}} cases:

\code{acc = dec.cor/N = (hi + cr)/(hi + mi + fa + cr)}

Values range from 0 (no correct prediction) to 1 (perfect prediction).

Importantly, correct decisions \code{\link{dec.cor}}
are not necessarily positive decisions \code{\link{dec.pos}}.
}
\examples{
# ways to work:
comp_acc(.10, .200, .300)  # => acc = 0.29
comp_acc(.50, .333, .666)  # => acc = 0.4995

# watch out for vectors:
prev.range <- seq(0, 1, by = .1)
comp_acc(prev.range, .5, .5)  # => 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5

# watch out for extreme values:
comp_acc(1, 1, 1)  #  => 1
comp_acc(1, 1, 0)  #  => 1

comp_acc(1, 0, 1)  #  => 0
comp_acc(1, 0, 0)  #  => 0

comp_acc(0, 1, 1)  #  => 1
comp_acc(0, 1, 0)  #  => 0

comp_acc(0, 0, 1)  #  => 1
comp_acc(0, 0, 0)  #  => 0


}
\seealso{
\code{\link{comp_sens}} and \code{\link{comp_PPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_prob}}, \code{\link{comp_sens}},
  \code{\link{comp_spec}}

Other metrics: \code{\link{accu}}, \code{\link{comp_accu}}
}
