% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq_num.R
\name{comp_freq}
\alias{comp_freq}
\title{Compute frequencies from (3 essential) probabilities.}
\usage{
comp_freq(prev = num$prev, sens = num$sens, spec = num$spec, N = num$N,
  round = TRUE)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}

\item{N}{The number of individuals in the population.
If \code{\link{N}} is unknown (\code{NA}),
a suitable minimum value is computed by \code{\link{comp_min_N}}.}

\item{round}{A Boolean value that determines whether frequencies are
rounded to the nearest integer. Default: \code{round = TRUE}.}
}
\value{
A list \code{\link{freq}} containing 9 frequency values.
}
\description{
\code{comp_freq} computes frequencies (typically
as rounded integers) given 3 basic probabilities --
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}} --
-- for a population of \code{\link{N}} individuals.
It returns a list of 9 frequencies \code{\link{freq}}
as its output.
}
\details{
In addition to \code{\link{prev}}, both
\code{\link{sens}} and \code{\link{spec}} are necessary arguments.
If only their complements \code{\link{mirt}} or \code{\link{fart}}
are known, use the wrapper function \code{\link{comp_freq_prob}}
which also accepts \code{\link{mirt}} and \code{\link{fart}} as inputs
(but requires that the entire set of provided probabilities is
sufficient and consistent).
Alternatively, use \code{\link{comp_complement}},
\code{\link{comp_comp_pair}}, or \code{\link{comp_complete_prob_set}}
to obtain the 3 essential probabilities.

\code{comp_freq} is the frequency counterpart to the
probability function \code{\link{comp_prob}}.

By default, \code{\link{comp_freq}} rounds frequencies
to nearest integers to avoid decimal values in
\code{\link{freq}}. Use \code{round = FALSE}
to switch off rounding.

Key relationships:

\enumerate{

\item to probabilities:
A population of \code{\link{N}} individuals can be split into 2 subsets
in 2 different ways:

\enumerate{
  \item by condition:
  The frequency \code{\link{cond.true}} depends on the prevalence \code{\link{prev}}
  and
  the frequency \code{\link{cond.false}} depends on the prevalence's complement \code{1 - \link{prev}}.

\item by decision:
  The frequency \code{\link{dec.pos}} depends on the proportion of positive decisions \code{\link{ppod}}
  and
  the frequency \code{\link{dec.neg}} depends on the proportion of negative decisions \code{1 - \link{ppod}}.

}

The population size \code{\link{N}} is a free parameter (independent of the
essential probabilities \code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}).

If \code{\link{N}} is unknown, a suitable minimum value can be computed by \code{\link{comp_min_N}}.

\item to other frequencies:
  In a population of size \code{\link{N}}
  the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}
}
\examples{
comp_freq()                  # => ok, using current defaults
length(comp_freq())          # => 11

# Ways to succeed:
comp_freq(prev = 1, sens = 1, spec = 1, 100)  # => ok, N hits (TP)
comp_freq(prev = 1, sens = 1, spec = 0, 100)  # => ok, N hits
comp_freq(prev = 1, sens = 0, spec = 1, 100)  # => ok, N misses (FN)
comp_freq(prev = 1, sens = 0, spec = 0, 100)  # => ok, N misses
comp_freq(prev = 0, sens = 1, spec = 1, 100)  # => ok, N correct rejections (TN)
comp_freq(prev = 0, sens = 1, spec = 0, 100)  # => ok, N false alarms (FP)

# Watch out for:
comp_freq(prev = 1, sens = 1, spec = 1, N = NA)  # => ok, but warning that N = 1 was computed
comp_freq(prev = 1, sens = 1, spec = 1, N =  0)  # => ok, but all 0 + warning (extreme case: N hits)
comp_freq(prev = .5, sens = .5, spec = .5, N = 10, round = TRUE)   # => ok, rounded (see mi and fa)
comp_freq(prev = .5, sens = .5, spec = .5, N = 10, round = FALSE)  # => ok, not rounded

# Ways to fail:
comp_freq(prev = NA,  sens = 1, spec = 1,  100)   # => NAs + warning (prev NA)
comp_freq(prev = 1,  sens = NA, spec = 1,  100)   # => NAs + warning (sens NA)
comp_freq(prev = 1,  sens = 1,  spec = NA, 100)   # => NAs + warning (spec NA)
comp_freq(prev = 8,  sens = 1,  spec = 1,  100)   # => NAs + warning (prev beyond range)
comp_freq(prev = 1,  sens = 8,  spec = 1,  100)   # => NAs + warning (sens beyond range)


}
\seealso{
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{freq}} contains current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{comp_comp_pair}} computes pairs of complements;
\code{\link{comp_complete_prob_set}} completes valid sets of probabilities;
\code{\link{comp_min_N}} computes a suitable population size \code{\link{N}} (if missing).

Other functions computing frequencies: \code{\link{comp_freq_freq}},
  \code{\link{comp_freq_prob}}, \code{\link{comp_min_N}},
  \code{\link{comp_popu}}, \code{\link{comp_prob_prob}}
}
