% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_freq.R
\name{comp_prob_freq}
\alias{comp_prob_freq}
\title{Compute probabilities from (4 essential) frequencies.}
\usage{
comp_prob_freq(hi = freq$hi, mi = freq$mi, fa = freq$fa, cr = freq$cr)
}
\arguments{
\item{hi}{The number of hits \code{\link{hi}} (or true positives).}

\item{mi}{The number of misses \code{\link{mi}} (or false negatives).}

\item{fa}{The number of false alarms \code{\link{fa}} (or false positives).}

\item{cr}{The number of correct rejections \code{\link{cr}} (or true negatives).}
}
\description{
\code{comp_prob_freq} computes current probability information
from 4 essential frequencies
(\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).
It returns a list of 10 probabilities \code{\link{prob}}
as its output.
}
\details{
Key relationships:

\itemize{

\item Other functions translating between representational formats:

\enumerate{

\item \code{comp_prob_freq} (defined here) is
   an analog to 3 other format conversion functions:

\item \code{\link{comp_freq_freq}} computes
   current \emph{frequency} information contained in \code{\link{freq}}
   from 4 essential frequencies
   (\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).

\item \code{\link{comp_freq_prob}} computes
   current \emph{frequency} information contained in \code{\link{freq}}
   from 3 essential probabilities
   (\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}}).

\item \code{\link{comp_prob_prob}} computes
   current \emph{probability} information contained in \code{\link{prob}}
   from 3 essential probabilities
   (\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}}).

}

\item Two perspectives:

A population of \code{\link{N}} individuals can be split into 2 subsets
in 2 different ways:

\enumerate{

\item by condition:

The frequency \code{\link{cond.true}} depends on the prevalence \code{\link{prev}}
   and
   the frequency \code{\link{cond.false}} depends on the prevalence's complement \code{1 - \link{prev}}.

\item by decision:

The frequency \code{\link{dec.pos}} depends on the proportion of positive decisions \code{\link{ppod}}
   and
   the frequency \code{\link{dec.neg}} depends on the proportion of negative decisions \code{1 - \link{ppod}}.

}

The population size \code{\link{N}} is a free parameter (independent of the
essential probabilities \code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}).

If \code{\link{N}} is unknown (\code{NA}), a suitable minimum value can be computed by \code{\link{comp_min_N}}.

\item Combinations of frequencies:

In a population of size \code{\link{N}} the following relationships hold:

\enumerate{

\item \code{\link{N} = \link{cond.true} + \link{cond.false} = (\link{hi} + \link{mi}) + (\link{fa} + \link{cr})} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg} = (\link{hi} + \link{fa}) + (\link{mi} + \link{cr})} (by decision)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)

}

The two perspectives (by condition vs. by decision) combine the 4 essential frequencies
  (i.e., \code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}})
  in 2 different ways.



\item Defining probabilities in terms of frequencies:

Probabilities \emph{are} -- determine, describe, or are defined as -- the relationships between frequencies.
Thus, they can be computed as ratios between frequencies.

The following relationships hold (and are used in computations):

\enumerate{

\item prevalence \code{\link{prev}}:

\code{\link{prev} = \link{cond.true}/\link{N}  =  (\link{hi} + \link{mi}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

\item sensitivity \code{\link{sens}}:

\code{\link{sens} = \link{hi}/\link{cond.true}  =  \link{hi} / (\link{hi} + \link{mi})  =  (1 - \link{mirt})}

\item miss rate \code{\link{mirt}}:

\code{\link{mirt} = \link{mi}/\link{cond.true}  =  \link{mi} / (\link{hi} + \link{mi})  =  (1 - \link{sens})}

\item specificity \code{\link{spec}}:

\code{\link{spec} = \link{cr}/\link{cond.false}  =  \link{cr} / (\link{fa} + \link{cr})  =  (1 - \link{fart})}

\item false alarm rate \code{\link{fart}}:

\code{\link{fart} = \link{fa}/\link{cond.false}  =  \link{fa} / (\link{fa} + \link{cr})  =  (1 - \link{spec})}



\item proportion of positive decisions \code{\link{ppod}}:

\code{\link{ppod} = \link{dec.pos}/\link{N}  =  (\link{hi} + \link{fa}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

\item positive predictive value \code{\link{PPV}}:

\code{\link{PPV} = \link{hi}/\link{dec.pos}  =  \link{hi} / (\link{hi} + \link{fa})  =  (1 - \link{FDR})}

\item negative predictive value \code{\link{NPV}}:

\code{\link{NPV} = \link{cr}/\link{dec.neg}  =  \link{cr} / (\link{mi} + \link{cr})  =  (1 - \link{FOR})}

\item false detection rate \code{\link{FDR}}:

\code{\link{FDR} = \link{fa}/\link{dec.pos}  =  \link{fa} / (\link{hi} + \link{fa})  =  (1 - \link{PPV})}

\item false omission rate \code{\link{FOR}}:

\code{\link{FOR} = \link{mi}/\link{dec.neg}  =  \link{mi} / (\link{mi} + \link{cr})  =  (1 - \link{NPV})}

}
}
}
\examples{
## Basics:
comp_prob_freq()
all.equal(prob, comp_prob_freq())  # => should be TRUE!


## Circular chain:
# 1. Current numeric parameters:
num

# 2. Compute all 10 probabilities in prob (from essential probabilities):
prob <- comp_prob()

# 3. Compute 9 frequencies in freq from probabilities:
freq <- comp_freq(round = FALSE)   # prevent rounding (to obtain same probabilities later)
freq

# 4. Compute all 10 probabilities again (but now from frequencies):
prob_freq <- comp_prob_freq()
prob_freq

# 5. Check equality of results (steps 2. and 4.):
all.equal(prob, prob_freq)  # => should be TRUE


}
\seealso{
\code{\link{comp_freq_freq}} computes current frequency information from (4 essential) frequencies;
\code{\link{comp_freq_prob}} computes current frequency information from (3 essential) probabilities;
\code{\link{comp_prob_prob}} computes current probability information from (3 essential) probabilities;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probability inputs;
\code{\link{is_freq}} verifies frequency inputs.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu}},
  \code{\link{comp_acc}}, \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob}},
  \code{\link{comp_sens}}, \code{\link{comp_spec}}

Other format conversion functions: \code{\link{comp_freq_freq}},
  \code{\link{comp_freq_prob}},
  \code{\link{comp_prob_prob}}
}
