% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal}
\alias{pal}
\title{List current values of basic color information.}
\format{An object of class \code{character} of length 11.}
\usage{
pal
}
\description{
\code{pal} is initialized to a vector of named elements (colors)
to define the color scheme for the current scenario that is
used throughout the \code{riskyr} package.
}
\details{
All color information corresponding to the current scenario
is stored as named colors in a vector \code{pal}.
To change a color, assign a new color to an existing element name.

\code{pal} currently contains colors with the following names:

\enumerate{

\item \code{N} Color representing the \emph{population} of \code{\link{N}} cases or individuals.

\item \code{true} Color representing cases of \code{\link{cond.true}}, for which the current condition is \code{TRUE}.

\item \code{false} Color representing cases of in \code{\link{cond.false}}, for which the current condition is \code{FALSE}.

\item \code{pos} Color representing cases of \code{\link{dec.pos}}, for which the current decision is \code{positive}.

\item \code{neg} Color representing cases in \code{\link{dec.neg}}, for which the current decision is \code{negative}.

\item \code{hi} Color representing \emph{hits} or true positives in \code{\link{hi}}
(i.e., correct cases for which the current condition is TRUE and the decision is positive).

\item \code{mi} Color representing \emph{misses} or false negatives in \code{\link{mi}}
(i.e., incorrect cases for which the current condition is TRUE but the decision is negative).

\item \code{fa} Color representing \emph{false alarms} or false positives in \code{\link{fa}}
(i.e., incorrect cases for which the current condition is FALSE but the decision is positive).

\item \code{cr} Color representing \emph{correct rejections} or true negatives in \code{\link{cr}}
(i.e., correct cases for which the current condition is FALSE and the decision is negative).

\item \code{ppv} Color representing \emph{positive predictive values} \code{\link{PPV}} (i.e., the conditional probability that
the condition is TRUE, provided that the decision is positive).

\item \code{npv} Color representing \emph{negative predictive values} \code{\link{NPV}} (i.e., the conditional probability that
the condition is FALSE, provided that the decision is negative).

}
}
\examples{
pal       # displays the vector of all current color names and values
pal["hi"] # displays the current color for hits (true positives)
pal["hi"] <- "green3" # defines a new color for hits (true positives)


}
\seealso{
\code{\link{init_pal}} initializes color information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{txt}} contains current text information;
\code{\link{init_txt}} initializes text information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other lists containing current scenario information: \code{\link{accu}},
  \code{\link{freq}}, \code{\link{num}},
  \code{\link{prob}}, \code{\link{txt}}
}
\keyword{datasets}
