% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{mirt}
\alias{mirt}
\alias{FNR}
\alias{beta}
\title{The miss rate of a decision process or diagnostic procedure.}
\format{An object of class \code{numeric} of length 1.}
\usage{
mirt
}
\description{
\code{mirt} defines a decision's miss rate value:
The conditional probability of the decision being negative
if the condition is \code{TRUE}.
}
\details{
Understanding or obtaining the miss rate \code{mirt}:

\itemize{

\item Definition: \code{sens} is the conditional probability
  for an incorrect negative decision given that
  the condition is \code{TRUE}:

\code{mirt = p(decision = negative | condition = TRUE)}

or the probability of failing to detect true cases
  (\code{condition = TRUE}).

\item Perspective:
  \code{mirt} further classifies
  the subset of \code{\link{cond_true}} individuals
  by decision (\code{mirt = mi/cond_true}).

\item Alternative names:
  false negative rate (\code{FNR}),
  rate of type-II errors (\code{beta})

\item Relationships:

a. \code{mirt} is the complement of the
  sensitivity \code{\link{sens}} (aka. hit rate \code{HR}):

\code{mirt = (1 - sens) = (1 - HR)}

b. \code{mirt} is the _opposite_ conditional probability
  -- but not the complement --
  of the false omission rate \code{\link{FOR}}:

\code{FOR = p(condition = TRUE | decision = negative)}

\item In terms of frequencies,
  \code{mirt} is the ratio of
  \code{\link{mi}} divided by \code{\link{cond_true}}
  (i.e., \code{\link{hi} + \link{mi}}):

\code{mirt = mi/cond_true = mi/(hi + mi)}

\item Dependencies:
  \code{mirt} is a feature of a decision process
  or diagnostic procedure and a measure of
  incorrect decisions (false negatives).

However, due to being a conditional probability,
  the value of \code{mirt} is not intrinsic to
  the decision process, but also depends on the
  condition's prevalence value \code{\link{prev}}.

}
}
\examples{
mirt <- .15     # => sets a miss rate of 15\%
mirt <- 15/100  # => (decision = negative) for 15 out of 100 people with (condition = TRUE)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Sensitivity_and_specificity}{Wikipedia} for additional information.
}
\seealso{
\code{\link{comp_mirt}} computes \code{mirt} as the complement of \code{\link{sens}};
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probabilities.

Other probabilities: \code{\link{FDR}}, \code{\link{FOR}},
  \code{\link{NPV}}, \code{\link{PPV}}, \code{\link{acc}},
  \code{\link{err}}, \code{\link{fart}},
  \code{\link{ppod}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}
}
\concept{probabilities}
\keyword{datasets}
