% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectbraiding.R
\name{riverdistancelist}
\alias{riverdistancelist}
\title{Multiple River Distances}
\usage{
riverdistancelist(startseg, endseg, startvert, endvert, rivers, reps = 100)
}
\arguments{
\item{startseg}{Segment number of the start of the route}

\item{endseg}{Segment number of the end of the route}

\item{startvert}{Vertex number of the start of the route}

\item{endvert}{Vertex number of the end of the route}

\item{rivers}{The river network object to use}

\item{reps}{Deprecated.  Was the number of randomized reorderings to try.}
}
\value{
A list with two objects, \code{$routes} being a list of detected routes in
  ascending order by distance, and \code{$distances} being the respective distances
  along the routes detected.
}
\description{
Used to calculate a list of possible river distances, in the
  event of braiding.  Calls \link{routelist} to detect a list of routes from
  one river location to another, and uses \link{riverdistance} to calculate
  the distances along those routes.  Different routes are detected by
  randomly reordering the segment numbers of the input river network object,
  thus changing the internal hierarchy of segment selection.
}
\note{
Since this function uses randomization, there is no guarantee that the
  list of routes will be comprehensive.  Larger numbers of reps can be tried,
  but computation can be slow, particularly in the presence of a complex
  river network.  It may be advantageous to use \link{trimriver} to create a
  smaller, more specific river network object to work with.
}
\examples{
data(KilleyW)
plot(x=KilleyW)

Killey.dists <- riverdistancelist(startseg=1, endseg=16, startvert=100, endvert=25,
   rivers=KilleyW, reps=1000)
Killey.dists  # 18 routes are detected.

# mapping the shortest route detected... 
riverdistance(startvert=100, endvert=25, path=Killey.dists$routes[[1]], rivers=KilleyW, map=TRUE)

# mapping the shortest longest detected... 
riverdistance(startvert=100, endvert=25, path=Killey.dists$routes[[18]], rivers=KilleyW, map=TRUE)
}
\author{
Matt Tyers
}

