% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup_verts.R
\name{cleanup_verts}
\alias{cleanup_verts}
\title{Interactive Cleanup of the Vertices of Individual Segments}
\usage{
cleanup_verts(rivers, startwith = 1)
}
\arguments{
\item{rivers}{The river network object to use}

\item{startwith}{The segment (number) to start with, defaulting to \code{1}.}
}
\value{
A new river network object, see
  \link{rivernetwork}
}
\description{
A trial version of a function for deep-cleaning a river network.

Sometimes a shapefile contains errors that are not obvious at an initial check, typically vertices that should not be there.  

This function steps through each segment in sequence, and allows the user to interactively remove vertices.
}
\note{
Stepping through a large and messy river network can be time-consuming.  To resume a cleanup session, use the \code{startwith=} argument and the last returned river network.  For example, if \code{rivers1 <- cleanup_verts(rivers)} were initially called and the user selected "save & close" at segment 100, cleanup can be resumed by calling \code{rivers2 <- cleanup_verts(rivers1, startwith=100)}.
}
\examples{
data(abstreams0,Koyukuk0,Kenai1)

# abstreams_fixed1 <- cleanup_verts(abstreams0)
# Koyukuk <- cleanup(Koyukuk0)
# Kenai <- cleanup(Kenai1)
}
\seealso{
line2network
}
\author{
Matt Tyers
}
