% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{isflowconnected}
\alias{isflowconnected}
\title{Check Flow-Connectedness}
\usage{
isflowconnected(seg1, seg2, rivers, stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{seg1}{First input segment}

\item{seg2}{Second input segment}

\item{rivers}{The river network object to use}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
Logical \code{TRUE} if the two segments are flow-connected, \code{FALSE} if they are not
}
\description{
Checks to see if two segments are flow-connected.  Called internally within \link{riverdirection} and \link{upstream}.
}
\note{
The river mouth must be specified (see \link{setmouth}).
}
\examples{
data(Gulk)
plot(Gulk)

Gulk <- setmouth(seg=1, vert=1, rivers=Gulk)

isflowconnected(seg1=13, seg2=14, rivers=Gulk)
isflowconnected(seg1=13, seg2=1, rivers=Gulk)
}
\author{
Matt Tyers
}
