% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segs_direction.R
\name{setmouth}
\alias{setmouth}
\title{Specify the Segment and Vertex of the Mouth of a River Network Object.}
\usage{
setmouth(seg, vert, rivers)
}
\arguments{
\item{seg}{The segment number to store for the mouth}

\item{vert}{The vertex number to store for the mouth}

\item{rivers}{The river network object to use}
}
\value{
A new river network object (see \link{rivernetwork})
}
\description{
Provides a user-friendly way of specifying the segment and
  vertex of the mouth (lowest point) of a river network object.
}
\note{
The mouth segment and vertex can also be specified using direct
  assignment to the \code{$mouth$seg} and \code{$mouth$vert} components of the river network
  object.

This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Gulk)

# say we know that segment 1 is the lowest segment in this river network, but we don't know 
# which end is the mouth.
showends(seg=1, rivers=Gulk)

# this means that the mouth is row 1, so we can specify this:
Gulk <- setmouth(seg=1, vert=1, rivers=Gulk)
}
\seealso{
\link{line2network}
}
\author{
Matt Tyers
}
