% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_preprocessing.R
\name{print_preprocessing}
\alias{print_preprocessing}
\title{Print the pre-processing model}
\usage{
print_preprocessing(
  x,
  format = "latex",
  signif.stars = TRUE,
  digits = 3,
  decimal.mark = getOption("OutDec"),
  booktabs = TRUE,
  summary = TRUE,
  likelihood = TRUE,
  arima = TRUE,
  regression = TRUE,
  ...
)
}
\arguments{
\item{x}{the object to print.}

\item{format}{output format: \code{"latex"} or \code{"html"}.}

\item{signif.stars}{logical; if \code{TRUE}, p-values are additionally encoded visually as ‘significance stars’ in order to help scanning of long coefficient tables}

\item{digits}{number of digits after the decimal point.}

\item{decimal.mark}{the character to be used to indicate the numeric decimal point.}

\item{booktabs}{boolean indicating whether to use or not the booktabs package (when \code{format = "latex"}).}

\item{summary}{boolean indicating whether to use or not the summary section.}

\item{likelihood}{boolean indicating whether to use or not the likelihood section.}

\item{arima}{boolean indicating whether to use or not the arima section.}

\item{regression}{boolean indicating whether to use or not the regression section.}

\item{...}{unused.}
}
\description{
Function to print the pre-processing model
}
\examples{
ipi <- RJDemetra::ipi_c_eu[, "FR"]

sa_x13 <- RJDemetra::jx13(ipi)
print_preprocessing(sa_x13, format = "latex")

\donttest{
sa_ts <- RJDemetra::tramoseats(ipi)
print_preprocessing(sa_ts, format = "html")
}

}
