% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{lang_args}
\alias{lang_args}
\alias{lang_args_names}
\title{Extract arguments from a call}
\usage{
lang_args(lang)

lang_args_names(lang)
}
\arguments{
\item{lang}{Can be a call (language object), a formula quoting a
call in the right-hand side, or a frame object from which to
extract the call expression.}
}
\value{
A named list of arguments.
}
\description{
Extract arguments from a call
}
\examples{
call <- quote(f(a, b))

# Subsetting a call returns the arguments converted to a language
# object:
call[-1]

# See also lang_tail() which returns the arguments without
# conversion as the original pairlist:
str(lang_tail(call))

# On the other hand, lang_args() returns a regular list that is
# often easier to work with:
str(lang_args(call))

# When the arguments are unnamed, a vector of empty strings is
# supplied (rather than NULL):
lang_args_names(call)
}
\seealso{
\code{\link[=lang_tail]{lang_tail()}}, \code{\link[=fn_fmls]{fn_fmls()}} and \code{\link[=fn_fmls_names]{fn_fmls_names()}}
}
