% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{as_env}
\alias{as_env}
\title{Coerce to an environment}
\usage{
as_env(x, parent = NULL)
}
\arguments{
\item{x}{An object to coerce.}

\item{parent}{A parent environment, \code{\link[=empty_env]{empty_env()}} by default. This
argument is only used when \code{x} is data actually coerced to an
environment (as opposed to data representing an environment, like
\code{NULL} representing the empty environment).}
}
\description{
\code{as_env()} coerces named vectors (including lists) to an
environment. It first checks that \code{x} is a dictionary (see
\code{\link[=is_dictionaryish]{is_dictionaryish()}}). If supplied an unnamed string, it returns the
corresponding package environment (see \code{\link[=pkg_env]{pkg_env()}}).
}
\details{
If \code{x} is an environment and \code{parent} is not \code{NULL}, the
environment is duplicated before being set a new parent. The return
value is therefore a different environment than \code{x}.
}
\examples{
# Coerce a named vector to an environment:
env <- as_env(mtcars)

# By default it gets the empty environment as parent:
identical(env_parent(env), empty_env())


# With strings it is a handy shortcut for pkg_env():
as_env("base")
as_env("rlang")

# With NULL it returns the empty environment:
as_env(NULL)
}
