% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{dots_list}
\alias{dots_list}
\alias{dots_splice}
\title{Extract dots with splicing semantics}
\usage{
dots_list(..., .ignore_empty = c("trailing", "none", "all"))

dots_splice(..., .ignore_empty = c("trailing", "none", "all"))
}
\arguments{
\item{...}{Arguments with explicit (\code{dots_list()}) or list
(\code{dots_splice()}) splicing semantics. The contents of spliced
arguments are embedded in the returned list.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}
}
\value{
A list of arguments. This list is always named: unnamed
arguments are named with the empty string \code{""}.
}
\description{
These functions evaluate all arguments contained in \code{...} and
return them as a list. They both splice their arguments if they
qualify for splicing. See \code{\link[=ll]{ll()}} for information about splicing
and below for the kind of arguments that qualify for splicing.
}
\details{
\code{dots_list()} has \emph{explicit splicing semantics}: it splices lists
that are explicitly marked for \link[=ll]{splicing} with the
\code{\link[=splice]{splice()}} adjective. \code{dots_splice()} on the other hand has \emph{list
splicing semantics}: in addition to lists marked explicitly for
splicing, \link[=is_bare_list]{bare} lists are spliced as well.
}
\examples{
# Compared to simply using list(...) to capture dots, dots_list()
# splices explicitly:
x <- list(1, 2)
dots_list(splice(x), 3)

# Unlike dots_splice(), it doesn't splice bare lists:
dots_list(x, 3)

# dots_splice() splices lists marked with splice() as well as bare
# lists:
x <- list(1, 2)
dots_splice(splice(x), 3)
dots_splice(x, 3)
}
\seealso{
\code{\link[=exprs]{exprs()}} for extracting dots without evaluation.
}
