% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{new_function}
\alias{new_function}
\title{Create a function}
\usage{
new_function(args, body, env = caller_env())
}
\arguments{
\item{args}{A named list of default arguments. Note that if you
want arguments that don't have defaults, you'll need to use the
special function \link{alist}, e.g. \code{alist(a = , b = 1)}}

\item{body}{A language object representing the code inside the
function. Usually this will be most easily generated with
\code{\link[base:quote]{base::quote()}}}

\item{env}{The parent environment of the function, defaults to the
calling environment of \code{new_function()}}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("stable")}

This constructs a new function given its three components:
list of arguments, body code and parent environment.
}
\examples{
f <- function(x) x + 3
g <- new_function(alist(x = ), quote(x + 3))

# The components of the functions are identical
identical(formals(f), formals(g))
identical(body(f), body(g))
identical(environment(f), environment(g))

# But the functions are not identical because f has src code reference
identical(f, g)

attr(f, "srcref") <- NULL
# Now they are:
stopifnot(identical(f, g))
}
