% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{op-na-default}
\alias{op-na-default}
\alias{\%|\%}
\title{Replace missing values}
\usage{
x \%|\% y
}
\arguments{
\item{x}{The original values.}

\item{y}{The replacement values. Must be of length 1 or the same length as \code{x}.}
}
\description{
This infix function is similar to \code{\%||\%} but is vectorised
and provides a default value for missing elements. It is faster
than using \code{\link[base:ifelse]{base::ifelse()}} and does not perform type conversions.
}
\examples{
c("a", "b", NA, "c") \%|\% "default"
c(1L, NA, 3L, NA, NA) \%|\% (6L:10L)
}
\seealso{
\link{op-null-default}
}
