% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_tools.r
\name{extra_bytes_attribute_tools}
\alias{extra_bytes_attribute_tools}
\alias{header_add_extrabytes}
\alias{header_add_extrabytes_manual}
\title{Extra Bytes Attributes Tools}
\usage{
header_add_extrabytes(header, data, name, desc)

header_add_extrabytes_manual(
  header,
  name,
  desc,
  type,
  offset = NULL,
  scale = NULL,
  max = NULL,
  min = NULL,
  NA_value = NULL
)
}
\arguments{
\item{header}{list}

\item{data}{vector. Data that must be added in the extrabytes attributes.}

\item{name}{character. The name of the extrabytes attributes to add in the file.}

\item{desc}{character. The description of the extrabytes attributes to add in the file.}

\item{type}{integer. The data type of the extrabytes attributes (page 25 of the spec).}

\item{scale, offset}{numeric. The scale and offset of the data. NULL if not relevant.}

\item{min, max}{numeric or integer. The minimum and maximum value of the data. NULL if not relevant.}

\item{NA_value}{numeric or integer. NA is not a valid value. At writing time it will be replaced by
this value that will be considered as NA. NULL if not relevant.}
}
\description{
Functions that update a header to describe Extra Bytes Attributes according to the
\href{http://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS specifications}
}
\examples{
data = data.frame(X = c(339002.889, 339002.983, 339002.918),
                  Y = c(5248000.515, 5248000.478, 5248000.318),
                  Z = c(975.589, 974.778, 974.471),
                  gpstime = c(269347.281418006, 269347.281428006, 269347.281438006),
                  Intensity = c(82L, 54L, 27L),
                  ReturnNumber = c(1L, 1L, 2L),
                  NumberOfReturns = c(1L, 1L, 2L),
                  ScanDirectionFlag = c(1L, 1L, 1L),
                  EdgeOfFlightline = c(1L, 0L, 0L),
                  Classification = c(1L, 1L, 1L),
                  ScanAngle = c(-21L, -21L, -21L),
                  UserData = c(32L, 32L, 32L),
                  PointSourceID = c(17L, 17L, 17L),
                  treeID = c(1L, 1L, 1L))

lasheader = header_create(data)
lasheader[["Variable Length Records"]]

lasheader = header_add_extrabytes(lasheader, data$treeID, "treeID", "An id for each tree")
lasheader[["Variable Length Records"]]
}
\seealso{
Other header_tools: 
\code{\link{crs_tools}},
\code{\link{public_header_block_tools}}
}
\concept{header_tools}
