% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/basemap.R
\name{basemap}
\alias{basemap}
\title{Define a Tile Basemap Layer}
\usage{
basemap(URL, name = NULL, alpha = 1, minZoom = 0, maxZoom = 18,
  tileSize = 256, tms = FALSE)
}
\arguments{
\item{URL}{a character string giving the tile server url or a the name of a pre-configured server.}

\item{name}{a character string to name the layer.}

\item{alpha}{a numeric value in \eqn{[0, 1]} setting the layer opacity.}

\item{minZoom,maxZoom}{numeric values setting the minimum and maximum zoom level.}

\item{tileSize}{a numeric value setting tile size (width and height in pixels, assuming tiles are square).}

\item{tms}{logical. If \code{TRUE}, inverses Y axis numbering for tiles (for TMS services)}
}
\value{
An object of class \code{basemap} which can be directly used in \code{\link{writeMap}}.
}
\description{
Define a new basemap layer from a tile server.
}
\details{
\code{URL} should have the form \code{'http://{s}.somedomain.com/somepath/{z}/{x}/{y}.png'}
with \code{{s}} a facultative subdomain, \code{{z}} the zoom level and \code{{x}}, \code{{y}} the coordinates.
\pkg{rleafmap} comes with a list of pre-configured servers. Names of these servers are returned
by the function \code{bmSource}.
}
\examples{
\dontrun{
 #A simple map with two nice basemaps.
 bm1 <- basemap("mapquest.map")
 bm2 <- basemap("stamen.watercolor")
 writeMap(bm1, bm2)
}
}
\seealso{
\code{\link{spLayer}} to define data layers.
}

