% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/writemap.R
\name{writeMap}
\alias{writeMap}
\title{Export and display the map}
\usage{
writeMap(..., dir = getwd(), prefix = "", width = 700, height = 400,
  setView = NULL, setZoom = NULL, interface = NULL, lightjson = FALSE,
  directView = c("viewer", "browser", "disabled"), leaflet.loc = "online")
}
\arguments{
\item{...}{\code{basemap} and \code{spl} objects to embed into the map}

\item{dir}{a character string giving the directory path to export the map.
Default is the working directory.}

\item{prefix}{a character string to add a prefix to file names.
This allows multiple exportations in the same directory.}

\item{width,height}{the width and height of the map, in pixels.}

\item{setView}{a numeric vector of the form \code{c(x, y)}
setting the initial geographical center of the map.}

\item{setZoom}{a numeric value setting the initial map zoom.}

\item{interface}{an \code{ui} object created with \code{\link{ui}}
to customize the interface controls.}

\item{lightjson}{logical. Should GeoJSON files size be reducedby supressing
extra whitespace characters and rounding numeric values? Default is \code{FALSE}.
This is currently not compatible with RMarkdown popups.}

\item{directView}{a character string indicating if and how should the map be displayed.
Default option "\code{viewer}" uses (if available) the RStudio HTML viewer to display the map,
"\code{browser}" opens the map into the web browser and "\code{disabled}" disables direct display.}

\item{leaflet.loc}{a character string specifying the location (directory) of the leaflet library.
If set to "\code{online}" (default), the library is loaded from the leaflet
official CDN and requires an internet connection.}
}
\description{
This function combines all the elements specified by the user and write
the corresponding HTML and Javascript code in a local directory.
}

