% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mincut.R
\name{AllPairsMinCut}
\alias{AllPairsMinCut}
\title{AllPairsMinCut}
\usage{
AllPairsMinCut(arcSources, arcTargets, arcWeights, numNodes, algorithm)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcWeights}{Vector corresponding to the weights of a graph's arcs}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Which algorithm to run. Choices include "GomoryHu"
 where GomoryHu is the default; see
<https://lemon.cs.elte.hu/pub/doc/1.3.1/a00182.html> for more information.}
}
\value{
A list containing three entries: 1) A list of predecessor nodes of
  each node in the graph, and 2) A list of weights of the predecessor edge
  of each node, and 3) A list of distances from the root node to each node.
}
\description{
Finds the all-pairs minimum cut tree, using the Gomory-Hu algorithm.
}
