% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{increment}
\alias{increment}
\alias{increments}
\title{Higher order increments}
\usage{
increment(r, i, k, path)

increments(k, r, path)
}
\arguments{
\item{r}{difference step, a natural number}

\item{i}{index of the point at which the increment is to be computed, a natural number.}

\item{k}{order of the increment, a natural number}

\item{path}{sample path for which a kth order increment is computed}
}
\description{
Difference of the kth order. Defined as following:
\deqn{\Delta_{i,k}^{n,r} X:= \sum_{j=0}^k (-1)^j{{k}\choose{j}}X_{(i-rj)/n}, i\geq rk.}
Index i here is a coordinate in terms of point_num. Although R uses vector indexes
that start from 1, increment has i varying from 0 to N, so that a
vector has a length N+1. It is done in order to comply with the notation of the paper.
This function doesn't allow for choosing frequency n. The frequency is determined by the
path supplied, thus n equals to either the length of the path in high frequency setting
or 1 in low frequency setting. increment() gives increments at certain point passed as i,
which is a vector here. increments() computes high order increments for the whole sample
path. The first function evaluates the formula above, while the second one uses structure
diff(diff(...)) because the formula is slower at higher k.
}
\examples{

m<-45; M<-60; N<-2^10-M
alpha<-0.8; H<-0.8; sigma<-0.3

lfsm<-path(N=N,m=m,M=M,alpha=alpha,H=H,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)$lfsm

tryCatch(
increment(r=1,i=length(lfsm),k=length(lfsm)+100,path=lfsm),
error=function(c) 'An error occures when k is larger then the length of the sample path')

increment(r=3,i=50,k=3,path=lfsm)


path=c(1,4,3,6,8,5,3,5,8,5,1,8,6)

r=2; k=3
n <- length(path) - 1
DeltaX = increment(seq(r*k, n), path = path, k = k, r = r)
DeltaX == increments(k=k,r=r,path)
}
\references{
\insertRef{MOP18}{rlfsm}
}
