% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{copy.NuggetKriging}
\alias{copy.NuggetKriging}
\alias{copy,NuggetKriging,NuggetKriging-method}
\title{Duplicate a NuggetKriging Model}
\usage{
\method{copy}{NuggetKriging}(object, ...)
}
\arguments{
\item{object}{An S3 NuggetKriging object.}

\item{...}{Not used.}
}
\value{
The copy of object.
}
\description{
Duplicate a NuggetKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

print(copy(k))
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
