% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcPurity}
\alias{calcPurity}
\title{Calculate purity}
\usage{
calcPurity(object, classes.compare, verbose = TRUE)
}
\arguments{
\item{object}{\code{liger} object. Should run quantileAlignSNF before calling.}

\item{classes.compare}{Clustering with which to compare (named vector).}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
Purity value.
}
\description{
Calculates purity for \code{liger} clustering and external clustering (true clusters/classes).
Purity can sometimes be a more useful metric when the clustering to be tested contains more
subgroups or clusters than the true clusters (or classes). Purity also ranges from 0 to 1,
with a score of 1 representing a pure, or accurate, clustering.
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete
ligerex <- quantile_norm(ligerex)
# toy clusters
cluster1 <- sample(c('type1', 'type2', 'type3'), ncol(ligerex@raw.data[[1]]), replace = TRUE)
names(cluster1) <- colnames(ligerex@raw.data[[1]])
cluster2 <- sample(c('type4', 'type5', 'type6'), ncol(ligerex@raw.data[[2]]), replace = TRUE)
names(cluster2) <- colnames(ligerex@raw.data[[2]])
# get ARI for first clustering
ari1 <- calcPurity(ligerex, cluster1)
# get ARI for second clustering
ari2 <- calcPurity(ligerex, cluster2)
}
}
