% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotGeneViolin}
\alias{plotGeneViolin}
\title{Plot violin plots for gene expression}
\usage{
plotGeneViolin(
  object,
  gene,
  methylation.indices = NULL,
  by.dataset = TRUE,
  return.plots = FALSE
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{gene}{Gene for which to plot relative expression.}

\item{methylation.indices}{Indices of datasets in object with methylation data (this data is not
magnified and put on log scale).}

\item{by.dataset}{Plots gene expression for each dataset separately (default TRUE).}

\item{return.plots}{Return ggplot objects instead of printing directly to console (default
FALSE).}
}
\value{
List of ggplot plot objects (only if return.plots TRUE, otherwise prints plots to
  console).
}
\description{
Generates violin plots of expression of specified gene for each dataset.
}
\examples{
\dontrun{
# ligerex (liger object based on in-memory datasets), factorization complete
# plot expression for CD4 and return plots
violin_plots <- plotGeneViolin(ligerex, "CD4", return.plots = TRUE)
# ligerex (liger object based on datasets in HDF5 format), factorization complete input
ligerex <- readSubset(ligerex, slot.use = "norm.data", max.cells = 5000)
violin_plots <- plotGeneViolin(ligerex, "CD4", return.plots = TRUE)
}
}
