% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{restoreOnlineLiger}
\alias{restoreOnlineLiger}
\title{Restore links (to hdf5 files) for reloaded online Liger object}
\usage{
restoreOnlineLiger(object, file.path = NULL)
}
\arguments{
\item{object}{\code{liger} object.}

\item{file.path}{List of paths to hdf5 files.}
}
\value{
\code{liger} object with restored links.
}
\description{
When loading the saved online Liger object in a new R session, the links to hdf5 files may be corrupted. This functions enables
the restoration of those links so that new analyses can be carried out.
}
\examples{
\dontrun{
# We want to restore the ligerex (liger object based on HDF5 files)
# It has broken connections to HDF5 files
# Call the following function and provide the paths to the correspoinding files
ligerex = restoreOnlineLiger(ligerex, file.path = list("path1/library1.h5", "path2/library2.h5"))
}
}
