% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotGenes}
\alias{plotGenes}
\title{Plot expression of multiple genes}
\usage{
plotGenes(object, genes, ...)
}
\arguments{
\item{object}{\code{liger} object. Should call runTSNE before calling.}

\item{genes}{Vector of gene names.}

\item{...}{arguments passed from \code{\link[rliger]{plotGene}}}
}
\value{
If returning single plot, returns ggplot object; if returning multiple plots; returns
  list of ggplot objects.
}
\description{
Uses plotGene to plot each gene (and dataset) on a separate page. It is recommended to call this
function into a PDF due to the large number of plots produced.
}
\examples{
\donttest{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iter = 1)
ligerex <- quantile_norm(ligerex)
ligerex <- runTSNE(ligerex)
plotGenes(ligerex, c("CD74", "NKG7"), pt.size = 1)
}
}
