% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{scaleNotCenter}
\alias{scaleNotCenter}
\title{Scale genes by root-mean-square across cells}
\usage{
scaleNotCenter(object, remove.missing = TRUE, chunk = 1000, verbose = TRUE)
}
\arguments{
\item{object}{\code{liger} object. Should call normalize and selectGenes before calling.}

\item{remove.missing}{Whether to remove cells from scale.data with no gene expression
(default TRUE).}

\item{chunk}{size of chunks in hdf5 file. (default 1000)}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with scale.data slot set.
}
\description{
This function scales normalized gene expression data after variable genes have been selected.
Note that the data is not mean-centered before scaling because expression values must remain
positive (NMF only accepts positive values). It also removes cells which do not have any
expression across the genes selected, by default.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
}
