% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotting.R
\name{.ggScatter}
\alias{.ggScatter}
\title{Produce single scatter plot with data frame passed from upstream}
\usage{
.ggScatter(
  plotDF,
  x,
  y,
  colorBy = NULL,
  shapeBy = NULL,
  dotOrder = c("shuffle", "ascending", "descending"),
  dotSize = getOption("ligerDotSize"),
  dotAlpha = 0.9,
  trimHigh = NULL,
  trimLow = NULL,
  zeroAsNA = TRUE,
  raster = NULL,
  labelBy = colorBy,
  labelText = TRUE,
  labelTextSize = 4,
  seed = 1,
  ...
)
}
\arguments{
\item{plotDF}{Data frame like object (fortifiable) that contains all
necessary information to make the plot.}

\item{x, y}{Available variable name in \code{cellMeta} slot to look for
the dot coordinates. See details.}

\item{colorBy, shapeBy}{See \code{\link{plotDimRed}}.}

\item{dotOrder}{Controls the order that each dot is added to the plot. Choose
from \code{"shuffle"}, \code{"ascending"}, or \code{"descending"}. Default
\code{"shuffle"}, useful when coloring by categories that overlaps (e.g.
"dataset"), \code{"ascending"} can be useful when coloring by a continuous
variable (e.g. gene expression) where high values needs more
highlight. \code{NULL} use default order.}

\item{dotSize, dotAlpha}{Numeric, controls the size or transparency of all
dots. Default \code{getOption("ligerDotSize")} (1) and \code{0.9}.}

\item{trimHigh, trimLow}{Numeric, limit the largest or smallest value of
continuous \code{colorBy} variable. Default \code{NULL}.}

\item{zeroAsNA}{Logical, whether to set zero values in continuous
\code{colorBy} variable to \code{NA} so the color of these value.}

\item{raster}{Logical, whether to rasterize the plot. Default \code{NULL}
automatically rasterize the plot when number of total cells to be plotted
exceeds 100,000.}

\item{labelBy}{A variable name available in \code{plotDF}. If the variable is
categorical (a factor), the label position will be the median coordinates of
all dots within the same group. Unique labeling in character vector for each
dot is also acceptable. Default \code{colorBy}.}

\item{labelText}{Logical, whether to show text label at the median position
of each categorical group specified by \code{colorBy}. Default \code{TRUE}.
Does not work when continuous coloring is specified.}

\item{labelTextSize}{Numeric, controls the size of label size when
\code{labelText = TRUE}. Default \code{4}.}

\item{seed}{Random seed for reproducibility. Default \code{1}.}

\item{...}{More theme setting arguments passed to
\code{\link{.ggplotLigerTheme}}.}
}
\value{
ggplot object by default. When \code{plotly = TRUE}, returns
plotly (htmlwidget) object.
}
\description{
Produce single scatter plot with data frame passed from upstream
}
\details{
Having package "ggrepel" installed can help adding tidier text
labels on the scatter plot.
}
